//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Nested Functions
//:
//: Readability and clearly describing the instructions placed in the code is vital when writing code that will be editted and reviewed by your colleagues.
//:
//: Nested functions are not often used in the tech industry, however they can sometimes really help to organize code and and much more clarity.
//:
//: Execute the code below.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


import Foundation // contains pow and sqrt

func circumferenceOfTriangle(side1: Double, side2: Double) -> Double {
    func calculateHypotenuse(side1: Double, side2: Double) -> Double {
        let hypotenuseSquared = pow(side1, 2) + pow(side2, 2)
        let hypotenuse = sqrt(hypotenuseSquared)
            return hypotenuse
    }
    
    let hypotenuse = calculateHypotenuse(side1: side1, side2: side2)
    let circumference = side1 + side2 + hypotenuse
    return circumference
}

let side1: Double = 5
let side2: Double = 10
let circumference = circumferenceOfTriangle(side1: side1, side2: side2)
print("side1: \(side1) side2: \(side2): circumference: \(circumference)")


//:
//: -------------------
//:
//: Let's simplify our example a little.
//:
//: Execute the code below.
//:
//: -------------------
//:


func doSomething() {
    func printSomething() {
        print("Something")
    }
}
doSomething()



//:
//: -------------------
//:
//: ## Task:
//:
//: In the code area below, write a nested function.
//:
//: The outer function should accept an array of strings and loop through each one.
//:
//: The purpose of the nested function is to test if a string is a palindrome or not.
//:
//: The outer function will loop through each word, test if it'a a palindrome and print it to the console if so.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: Nested functions have access to variables declared in their outer function.
//:
//: If they're used without passing them in as input parameters then we say they're "captured". We must remember that functions are stored as objects in memory.
//:
/*:
 
 */
//:
//: Execute the code below. Run it a few times and try to understand how the `y` variable was captured inside the addFive function.
//:
//: -------------------
//:
//: * callout(💡 Tip):
//:     → Functions are reference types.
//:
//:     Inside the `returnThirty` function a new instance of the `addFive` function is created with its name acting as the variable used to access it.
//:
//:     By appending brackets `()` to the variable name we instruct the code to execute the function.
//:
//:     Each time the instance is executed another `5` is added to the `y` variable.
//:
//: -------------------
//:


// capturing a value type in a nested function
func returnThirty() -> Int {
    var y = 10 // value type
    func addFive() -> Int {
        y += 5
        return y
    }
    var number = addFive() // y increases in size. Only one instance of this nested function exists in memory
    number = addFive() // 20
    number = addFive() // 25
    number = addFive() // 30
    return number
}
var thirty = returnThirty()

// what value will we print to the console?
var whatNumberIsThis = returnThirty()
whatNumberIsThis = returnThirty()
whatNumberIsThis = returnThirty()
whatNumberIsThis = returnThirty()
whatNumberIsThis = returnThirty()
print(whatNumberIsThis)



//:
//: -------------------
//:
//: ## Task:
//:
//: Let's try simplifying the example.
//:
//: Execute the code below and write below it an almost identical function to return `40`.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// capturing a value type in a nested function
func returnFourteen() -> Int {
    var y = 10 // Int is a struct. A struct is a value type
    func addOne() -> Int {
        y += 1
        return y
    }
    var number = addOne()
    number = addOne() // 12
    number = addOne() // 13
    number = addOne() // 14
    return number
}
var fourteen = returnFourteen()
print(fourteen)


// write code here


//:
//: -------------------
//:
/*:
  * Callout(Tip 💡):
    Be careful when capturing values.
 
    We recommend to take a moment and write some extra code to test that its behaviour matches what you had predicted.
 
    "Memory management" is a topic we'll need to discuss. It's important to think about.
 
    We'll discuss it in great detail later.
 */
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:
